/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatTripleInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class RechercheObjets {
    private static Logger log = Logger.getLogger(RechercheObjets.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, int n, String string) throws ExceptionObjet, ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                String string2 = "inconnu";
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = null;
                switch (n) {
                    case 1: {
                        string2 = "certificat";
                        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
                        cK_ATTRIBUTEArray[0].type = 0L;
                        cK_ATTRIBUTEArray[0].pValue = 1L;
                        break;
                    }
                    case 2: {
                        string2 = "cl\u00e9 publique";
                        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
                        cK_ATTRIBUTEArray[0].type = 0L;
                        cK_ATTRIBUTEArray[0].pValue = 2L;
                        break;
                    }
                    case 3: {
                        string2 = "cl\u00e9 priv\u00e9e";
                        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
                        cK_ATTRIBUTEArray[0].type = 0L;
                        cK_ATTRIBUTEArray[0].pValue = 3L;
                        break;
                    }
                    case 4: {
                        string2 = "de donn\u00e9es applicatives";
                        int n2 = 1;
                        if (string != null) {
                            n2 = 2;
                        }
                        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[n2];
                        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
                        cK_ATTRIBUTEArray[0].type = 0L;
                        cK_ATTRIBUTEArray[0].pValue = 0L;
                        if (n2 <= 1 || string == null) break;
                        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
                        cK_ATTRIBUTEArray[1].type = 3L;
                        cK_ATTRIBUTEArray[1].pValue = string;
                        break;
                    }
                    default: {
                        log.error((Object)("Type d'objet " + n + " non g\u00e9r\u00e9"));
                        throw new ExceptionTraitement(25, "Type d'objet non g\u00e9r\u00e9");
                    }
                }
                ResultatTripleInfo resultatTripleInfo = new ResultatTripleInfo("Recherche d'objet(s) de type " + string2 + " (Initialisation (C_FindObjectsInit))", "Recherche d'objet(s) de type " + string2 + " (Recherche (C_FindObjects))", "Recherche d'objet(s) de type " + string2 + " (Finalisation (C_FindObjectsFinal))");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                long[] lArray = null;
                boolean bl = false;
                try {
                    pKCS11.C_FindObjectsInit(l, cK_ATTRIBUTEArray);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatTripleInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                    bl = true;
                    resultatTripleInfo.setCodeRetour2(-1L);
                    resultatTripleInfo.appendOperation2(" NON EXECUTEE!");
                    resultatTripleInfo.setCodeRetour3(-1L);
                    resultatTripleInfo.appendOperation3(" NON EXECUTEE!");
                }
                try {
                    if (!bl) {
                        lArray = pKCS11.C_FindObjects(l, 32L);
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatTripleInfo.setCodeRetour2(pKCS11Exception.getErrorCode());
                    bl = true;
                    resultatTripleInfo.setCodeRetour3(-1L);
                }
                try {
                    if (!bl) {
                        pKCS11.C_FindObjectsFinal(l);
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatTripleInfo.setCodeRetour3(pKCS11Exception.getErrorCode());
                }
                if (lArray != null && !bl) {
                    linkedHashMap.put("Nombre d'objets:", Integer.toString(lArray.length));
                    for (int i = 0; i < lArray.length; ++i) {
                        long l2 = lArray[i];
                        linkedHashMap.put("Identifiant de l'objet " + (i + 1), Long.toString(l2));
                        try {
                            if (cK_ATTRIBUTEArray != null && cK_ATTRIBUTEArray[0] != null && ((Long)cK_ATTRIBUTEArray[0].pValue == 3L || (Long)cK_ATTRIBUTEArray[0].pValue == 2L || (Long)cK_ATTRIBUTEArray[0].pValue == 4L)) {
                                long[] lArray2 = new long[]{l2, (Long)cK_ATTRIBUTEArray[0].pValue};
                                resultatTripleInfo.getObjets().add(lArray2);
                            }
                            if (cK_ATTRIBUTEArray == null || cK_ATTRIBUTEArray[0] == null || (Long)cK_ATTRIBUTEArray[0].pValue != 0L) continue;
                            resultatTripleInfo.getObjets().add(l2);
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            throw new ExceptionTraitement(25, "Une erreur est survenue lors de la recherche des objets");
                        }
                    }
                }
                resultatTripleInfo.setInfos(linkedHashMap);
                return resultatTripleInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(25, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionObjet) {
                throw (ExceptionObjet)throwable;
            }
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(25, "Une erreur inattendue est survenue");
        }
    }
}

